/**
* stable and jasmine-tested version von 8.2.2021
*/
var StimmzettelController = {};
var DEVELOP = false;
var PROBESTIMMZETTEL = true;
/* 
* Dieses Objekt ist eine Schnittstelle zwinschen die DOM-Elementen der Stimmzettel und der berchnete Stimmzettel 
*/
var JSONStimmzettel = {};
//initiale state von Stimmzettel
JSONStimmzettelInit = {};
JSONStimmzettelPrev = {};
var STIMMZETTEL_CONFIG = {}; // das Globale-Object dass von das Abfrage kommt.  (StimmzettelConfig)
var ENABLE_PREVENT_CLOSE = true;
$(function () {
	reheightStimmzettelViewSimple();
	if (typeof JASMINE_TEST === 'undefined') {
		if (DEVELOP == false && PROBESTIMMZETTEL == false) { //prod
			form = document.getElementById('stimmzettel-form');
			if (form != null) {
				$.getJSON(updateHrefCsrf("stimmzettelConfig"), function (data) {
					console.log('loading stimmzettel config...prod'); // in prod es ist gut dass wird geloaded, weil in cache den Browser bleibt
					STIMMZETTEL_CONFIG = data;
					StimmzettelController.start();
				})
					.fail(function () {
						console.error("error stimmzettelConfig nicht verfgbar");
					});
			}
		} else if (DEVELOP == true && PROBESTIMMZETTEL == false) { //manual testing
			$.getScript("../../fakeAbfrage.js", function (data, textStatus, jqxhr) { // test daten
				fakeAbfrage();
				StimmzettelController.start();
				console.log("test data was loaded");
			})
				.fail(function () {
					console.error('test data failed...');
				});
		} else if (PROBESTIMMZETTEL == true) {
			fakeAbfrage();
			StimmzettelController.start();
			console.log("Probestimmzettel...");
		}
	} else { // automatic testing
		console.log('jasmine testing...');
	}
})

StimmzettelController.start = function () {
	if (DEVELOP) console.log('stimmzettelController gestarted...');
	if (typeof JASMINE_TEST === 'undefined') {
		var kandidatNameElementsArr = StimmzettelController.getElementsByIdWildCard("stimmzettelpos*-kandidat*-nennung*");
		var kandidatSpalteElementsArr = StimmzettelController.getElementsByIdWildCard("stimmzettelpos*-kandidat*-spalte*");
		var kopfStimmeElementsArr = StimmzettelController.getElementsByIdWildCard("stimmzettelpos*-kopfstimme*");
		var wahlvorschlagMessageElementsArr = StimmzettelController.getElementsByIdWildCard("wahlvorschlag*-msg");

		//init stimmzettel as JsonObjekt (initialisierung nur wenn nicht stornieren existiert)
		var storniereElement = document.getElementById("stimmzettel-storno");
		if (storniereElement == null) {
			StimmzettelController.initJSONStimmzettel(kandidatNameElementsArr, kandidatSpalteElementsArr, kopfStimmeElementsArr, wahlvorschlagMessageElementsArr);
		}

		//init Event Listeners
		if (DEVELOP) console.log('Events loading...')
		StimmzettelController.speichernAndStorno();
		if (PROBESTIMMZETTEL == false) StimmzettelController.ungueltigeStimmen();
		if (PROBESTIMMZETTEL == false) StimmzettelController.askBeforeLeave(ENABLE_PREVENT_CLOSE);
		if (storniereElement == null) {
			if (PROBESTIMMZETTEL == false) {
				StimmzettelController.addShiftEnterSchnellerfassung();				
				StimmzettelController.addOnClickSchnellerfassung();
			}
			StimmzettelController.addOnClick(kandidatNameElementsArr);
			StimmzettelController.addOnClick(kandidatSpalteElementsArr);
			StimmzettelController.addOnKeyDown(kandidatSpalteElementsArr);
			StimmzettelController.addOnClick(kopfStimmeElementsArr);
		}
	}
}
StimmzettelController.preventCloseWindow = function (e) {
	if (ENABLE_PREVENT_CLOSE) {
		if (DEVELOP) console.log('prevent close window enabled...');
		if (JSONStimmzettel.hinweisText == null || JSONStimmzettel.hinweisText.text.length === 0) {
			//
		} else {
			e.preventDefault();
			e.returnValue = '';
		}
	} else {
		if (DEVELOP) console.log('prevent close window disabled...');
	}
}

StimmzettelController.askBeforeLeave = function (enabled) {
	if (enabled) {
		window.addEventListener("beforeunload", function (e) { StimmzettelController.preventCloseWindow(e); });
	} else {
		window.removeEventListener("beforeunload", function () { });
	}
}

/*
* INIT STIMMZETTEL AS JSON OBJECT
*/
StimmzettelController.initJSONStimmzettel = function (arr1, arr2, arr3, arr4) {
	kandidatNamen = []
	for (var i = 0; i < arr1.length; i++) {
		obj = StimmzettelController.elementToJson(arr1[i]);
		obj["name"] = document.getElementById(arr1[i]).innerText
		obj["clicked"] = false;
		obj["error"] = false;
		obj["canceled"] = false;
		kandidatNamen.push(obj);
	}

	kandidatSpalten = []
	for (var i = 0; i < arr2.length; i++) {
		obj = StimmzettelController.elementToJson(arr2[i]);
		obj["clicked"] = false;
		obj["selected"] = false;
		obj["error"] = false;
		obj["value"] = "";
		kandidatSpalten.push(obj);
	}

	kopfStimmen = []
	for (var i = 0; i < arr3.length; i++) {
		obj = StimmzettelController.elementToJson(arr3[i]);
		obj["clicked"] = false;
		obj["clicked1"] = false;
		obj["clicked2"] = false;
		obj["clicked3"] = false;
		obj["clicked4"] = false;
		obj["error"] = false;
		kopfStimmen.push(obj);
	}

	wahlvorschlagMessages = []
	for (var i = 0; i < arr4.length; i++) {
		obj = StimmzettelController.elementToJson(arr4[i]);
		obj["clicked"] = false;
		obj["error"] = false;
		obj["warning"] = true;
		obj["stimmen"] = 0;
		wahlvorschlagMessages.push(obj);
	}

	JSONStimmzettel["kandidatNamen"] = kandidatNamen;
	JSONStimmzettel["kandidatSpalten"] = kandidatSpalten;
	JSONStimmzettel["kopfStimmen"] = kopfStimmen;
	JSONStimmzettel["wahlvorschlagMessages"] = wahlvorschlagMessages;
	JSONStimmzettel["hinweisText"] = { text: "", text1: "", text2: "", text3: "", enabled: false, success: false };
	JSONStimmzettel["statistikbuchstabe"] = null;
	JSONStimmzettel["ungueltigestimmen"] = null;
	JSONStimmzettel["bemerkung"] = null;
	JSONStimmzettel["schnellerfassung"] = null;
	JSONStimmzettel["totKandidaten"] = StimmzettelController.countKandidaten(kandidatNamen);
	// INITIAL STATE JsonStimmzettel init
	JSONStimmzettelInit = JSON.parse(JSON.stringify(JSONStimmzettel));
}

StimmzettelController.emptyallinputs = function () {
	$('#confirm-delete').remove();
	$('#stimmzettel-form').after(StimmzettelController.loadModalWindowEmptyAllInputs());
	$('#confirm-delete').modal('show');
	StimmzettelController.eventListenerModalEmptyAll();
}

StimmzettelController.eventListenerModalEmptyAll = function () {
	$('#erase-all').on('click', function (e) {
		FOCUS_POS = null;
		JSONStimmzettel = JSON.parse(JSON.stringify(JSONStimmzettelInit));
		StimmzettelController.renderStimmzettel(JSONStimmzettel);
		var kopfStimmeElementsArr = StimmzettelController.getElementsByIdWildCard("stimmzettelpos*-kopfstimme*");
		kopfStimmeElementsArr.forEach(function (el) {
			e = document.getElementById(el);
			e.checked = false;
		});
	});
}

StimmzettelController.errorModalMessage = function (title, text) {
	return '<div class="modal fade" id="error-msg" tabindex="-1" role="dialog" aria-labelledby="EingabeFehler" aria-hidden="true">\
	<div class="modal-dialog">\
		<div class="modal-content">\
			<div class="modal-header">\
			<h4 class="modal-title" id="EingabeFehler">' + title + '</h4>\
			<button id="close-x" type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>\
			</div>\
			<div class="modal-body">\
				<p>'+ text + '</p>\
				<p class="debug-url"></p>\
			</div>\
			<div class="modal-footer">\
				<button id="close-ok" type="button" class="btn btn-outline-primary" data-dismiss="modal" tabindex="1" autofocus>Ok</button>\
			</div>\
		</div>\
	</div>\
</div>';
}

StimmzettelController.infoModalMessage = function (title, text) {
	return '<div class="modal fade" id="info-msg" tabindex="-1" role="dialog" aria-labelledby="InfoModal" aria-hidden="true">\
	<div class="modal-dialog">\
		<div class="modal-content">\
			<div class="modal-header">\
			<h4 class="modal-title" id="InfoModal">' + title + '</h4>\
			<button id="close-x" type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>\
			</div>\
			<div class="modal-body">\
				<p>'+ text + '</p>\
				<p class="debug-url"></p>\
			</div>\
			<div class="modal-footer">\
				<button id="close-ok" type="button" class="btn btn-outline-primary" data-dismiss="modal" tabindex="1" autofocus>Ok</button>\
			</div>\
		</div>\
	</div>\
</div>';
}

StimmzettelController.loadModalWindowEmptyAllInputs = function () {
	return '<div class="modal fade" id="confirm-delete" tabindex="-1" role="dialog" aria-labelledby="modalConfirmLabel" aria-hidden="true">\
	<div class="modal-dialog">\
		<div class="modal-content">\
			<div class="modal-header">\
			<h4 class="modal-title" id="modalConfirmLabel">Zurücksetzen bestätigen</h4>\
			<button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>\
			</div>\
			<div class="modal-body">\
				<p>Möchten Sie wirklich alle Eingaben zurücksetzen?</p>\
				<p class="debug-url"></p>\
			</div>\
			<div class="modal-footer">\
				<button type="button" class="btn btn-outline-primary" data-dismiss="modal">Nein</button>\
				<button type="button" id ="erase-all" data-dismiss="modal" class="btn btn-warning">Ja</button>\
			</div>\
		</div>\
	</div>\
</div>';
}

StimmzettelController.countKandidaten = function (kandidatNamen) {
	tot = 0;
	kandidatNamen.forEach(function (s) {
		if (s.nennung == "1") tot++;
	});
	return tot;
}

/**
 * LISTENERS
 */
/**
 * FUNKTIONEN SPEICHERN, STORNO, SCHNELLERFASSUNG
 */
StimmzettelController.speichernAction = function () {
	ENABLE_PREVENT_CLOSE = false;
	StimmzettelController.askBeforeLeave(ENABLE_PREVENT_CLOSE);
	btn = $(this);
	dataObj = StimmzettelController.getGestricheneAsObjectForSubmit()
	var options = {
		type: "POST",
		url: updateHrefCsrf('erfassung?action=20170928'),
		data: dataObj,
		success: function () {
			btn.attr("disabled", false);
		}
	};
	$('#stimmzettel-form').ajaxForm(options);
}
StimmzettelController.runEventUngultigeStimmen = function (e) {
	value = ('' + $(e.target).val()).replace(/\D/g,'');	
	totStimmen = STIMMZETTEL_CONFIG.stimmzettel.anzahlstimmen;
	$(e.target).val(value);	
	if (/^[0-9]+$/i.test(value) || value == "") {
		parsedInt = parseInt(value);	
		if (parsedInt > totStimmen) {
			LAST_FOCUS_ELEMENT_STIMME = e.target;
			StimmzettelController.showErrorMessage("Fehler","Es ist nicht erlaubt mehr ungültige Stimmen als die Anzahl der zur Verfügung stehenden Stimmen insgeamt hinzuzufügen\n\n. Der Anzahl der zur Verfügung stehenden Stimmen ist: " + totStimmen);
			$(e.target).val(totStimmen);
			parsedInt = totStimmen;
		}
		StimmzettelValidator.ungueltigeStimmen(parsedInt);
	}
	else {
		parsedInt = parseInt(value);
		if (parsedInt < 0 ) {			
			$(e.target).val(0);
		}		
		e.preventDefault();
		e.stopPropagation();
	}
}

StimmzettelController.ungueltigeStimmen = function () {
	document.getElementById("stimmzettel-ungueltige-stimmen").addEventListener("input", function (e) {
		StimmzettelController.runEventUngultigeStimmen(e);
	})
}

StimmzettelController.speichernAndStorno = function () {

	$('#stimmzettel-speichern').click(function (e) {
		StimmzettelController.speichernAction();
	});

	$('#stimmzettel-storno').click(function () {
		$.get("modal_storniereStimmzettel.html", function (data) {
			$(data).modal().on('hidden.bs.modal', function (e) {
				$("#storniereStimmzettelModal").remove();
			}).on('shown.bs.modal', function (e) {
				$("#button-stornieren").focus();
			});
		});
		return false;
	});
}

StimmzettelController.addShiftEnterSchnellerfassung = function () {
	document.getElementById("schnellerfassung-input").addEventListener("keydown", function (e) {
		//SHIFT-ENTER
		//Reset die Fehelrs
		$('#schnellerfassung-error').text('');
		$('#schnellerfassung-error').removeClass('alert').removeClass('alert-danger').removeClass('alert-schnellerfassung');
		$('#schnellerfassung-input').removeClass('is-invalid');
		$('#schnellerfassung-input').removeClass('is-valid');
		if (e.shiftKey && e.keyCode == 13) {
			StimmzettelValidator.schnellerfassung(true); // nomessage wenn Leer ist			
			val = document.getElementById("schnellerfassung-input").value;
			if (SchnellerfassungsErrorNow === "" || val === "") {
				document.getElementById("stimmzettel-speichern").click();
			}
			if ($("#schnellerfassung-input").val() == "") {
				$('#schnellerfassung-error').text('');
				$('#schnellerfassung-error').removeClass('alert').removeClass('alert-danger').removeClass('alert-schnellerfassung');
				$('#schnellerfassung-input').removeClass('is-invalid');
				$('#schnellerfassung-input').removeClass('is-valid');
			}
			e.preventDefault();
		}
		if (e.keyCode == 13) {
			e.preventDefault();
			JSONStimmzettelPrev = JSON.parse(JSON.stringify(JSONStimmzettel));
			StimmzettelValidator.schnellerfassung();
			StimmzettelController.scrollOnIntersection(JSONStimmzettelPrev, JSONStimmzettel);
			StimmzettelController.focusOnSchnellerfassung();
			e.preventDefault();
		}
	});
}

StimmzettelController.addOnClick = function (arr) {
	if (typeof arr === 'string' || arr instanceof String) {
		//einige Element
		StimmzettelController.addOnClickById(arr);
	} else if ($.isArray(arr)) {
		for (var i = 0; i < arr.length; i++) {
			StimmzettelController.addOnClickById(arr[i]);
		}
	}
	else {
		console.error('not valid object. addOnClick need a string or an array of string (the name of the ids)');
	}
}

StimmzettelController.addOnClickSchnellerfassung = function(){
	if (DEVELOP){
		//
	} else {	
	document.getElementById('help-schnellerfassung').addEventListener("click", function () {		    
			LAST_FOCUS_ELEMENT_STIMME = document.getElementById('schnellerfassung-input');
			StimmzettelController.showInfoMessage(STIMMZETTEL_CONFIG.schnellererfassung.title,STIMMZETTEL_CONFIG.schnellererfassung.text);
		});
	}
}

StimmzettelController.addOnKeyDown = function (arr) {
	if (typeof arr === 'string' || arr instanceof String) {
		//einige Element
		StimmzettelController.addOnKeyDownById(arr);
	} else if ($.isArray(arr)) {
		for (var i = 0; i < arr.length; i++) {
			StimmzettelController.addOnKeyDownById(arr[i]);
		}
	}
	else {
		console.error('not valid object. addOnClick need a string or an array of string (the name of the ids)');
	}
}

StimmzettelController.addOnClickById = function (id) {
	document.getElementById(id).addEventListener("click", function () {
		clickedObject = StimmzettelController.elementToJson(id);
		StimmzettelController.preValidate(clickedObject);
	});
}
ALERT_ON = false;
PRESSED_TIMES = 0;
LAST_FOCUS_ELEMENT_STIMME = null;
StimmzettelController.addOnKeyDownById = function (id) {
	document.getElementById(id).addEventListener("keydown", function (e) {
		LAST_FOCUS_ELEMENT_STIMME = e.target;
		PRESSED_TIMES = PRESSED_TIMES + 1;
		keyInt = parseInt(e.key);
		isValid = false;
		isOtherInput = false;
		value = "";
		var x = e.key.toUpperCase();
		if (x == "X" || /^[1-9]+$/i.test(e.key) || e.key == "Delete") {
			isValid = true;
			if (e.key != "Delete") value = e.key;
		}

		if (e.key == "ArrowRight") {
			isOtherInput = true;
			if (DEVELOP) console.log('next element');
			nextRight = $(document.getElementById(id).parentElement).next()[0];
			if (DEVELOP) console.log(nextRight);
			if (typeof nextRight !== 'undefined') {
				$(document.getElementById(id).parentElement).next()[0].childNodes[0].focus();
			} else {
				nextElement = $(document.getElementById(id).parentElement.parentElement.parentElement.parentElement.parentElement).next()[0];
				if (nextElement !== undefined) {
					nextRight = nextElement.children[0].children[0].children[2].children[2].children[0];
					nextRight.focus();
				}
			}
		}

		if (e.key == "Tab") {
			isOtherInput = true;
			var tabables = $("*[tabindex != '-1']:visible");
			var index = tabables.index(this);
			className = tabables.eq(index + 2)[0].className;
			if (className == "stz-validate-stimme") { tabables.eq(index + 2)[0].focus() }
			else { tabables.eq(index + 6)[0].focus() };
		}

		if (e.key == "Control") {
			return null;
		}

		if (e.key == "Backspace") {
			isOtherInput = true;
			this.setAttribute("type", "text");
			this.setAttribute("value", "");
			inputObject = StimmzettelController.elementToJson(id);
			StimmzettelController.preValidateInput(inputObject);
		}

		if (e.key == "ArrowLeft") {
			isOtherInput = true;
			nextLeft = $(document.getElementById(id).parentElement).prev()[0];
			if (nextLeft.childNodes[0].nodeName !== 'DIV') {
				toFocus = $(document.getElementById(id).parentElement).prev()[0];
				if (PROBESTIMMZETTEL == false) {
					$(document.getElementById(id).parentElement).prev()[0].childNodes[0].focus();
				} else {
					if (nextLeft.childNodes[0].nodeName.includes('#text') == false) {
						$(document.getElementById(id).parentElement).prev()[0].childNodes[0].focus();
					} else {
						prevElement = $(document.getElementById(id).parentElement.parentElement.parentElement.parentElement.parentElement).prev()[0];
						if (prevElement !== 'undefined') { prevElement.firstElementChild.children[0].children[2].children[2].firstChild.focus(); }
					}
				}
			} else {
				prevElement = $(document.getElementById(id).parentElement.parentElement.parentElement.parentElement.parentElement).prev()[0];
				if (typeof prevElement !== 'undefined') {
					nextLeft = prevElement.children[0].children[0].children[2].children[2].children[0];
					nextLeft.focus();
				}

			}
		}

		if (e.key == "ArrowDown") {
			isOtherInput = true;
			if (DEVELOP) console.log('next element down');
			nextDown = $(document.getElementById(id).parentElement.parentElement).next()[0];
			if (PROBESTIMMZETTEL == false) {
				if (typeof nextDown.childNodes[5] !== 'undefined') nextDown.childNodes[5].childNodes[0].focus();
			} else {
				if (nextDown.children[2] !== 'undefined') nextDown.children[2].children[0].focus();
			}
		}

		if (e.key == "ArrowUp") {
			isOtherInput = true;
			if (DEVELOP) console.log('next element up');
			nextUp = $(document.getElementById(id).parentElement.parentElement).prev()[0];
			if (PROBESTIMMZETTEL == false) {
				if (typeof nextUp.childNodes[5] !== 'undefined') nextUp.childNodes[5].childNodes[0].focus();
			} else {
				if (nextUp.children[2] !== 'undefined') nextUp.children[2].children[0].focus();
			}
		}

		if (isValid) {
			if (DEVELOP) console.log('validate');
			this.setAttribute("type", "text");
			this.setAttribute("value", value);
			inputObject = StimmzettelController.elementToJson(id);
			StimmzettelController.preValidateInput(inputObject);
		} else {
			if (PRESSED_TIMES > 1) {
				if (e.key == "ArrowRight" || e.key == "ArrowLeft" || e.key == "Delete" || e.key == "ArrowUp" || e.key == "ArrowDown") {
					// 
				} else {
					PRESSED_TIMES = 0;
					if (isOtherInput == false)
						StimmzettelController.printInvalidInput(e);
					e.preventDefault();
					e.stopPropagation();
					return
				}
			};
			if (isOtherInput == false) StimmzettelController.printInvalidInput(e);
			e.preventDefault();
			e.stopPropagation();
		}
	})
}

StimmzettelController.showInfoMessage = function (titel, text) {
	$('#info-msg').remove();
	//stimmzettel-form
	$('#stimmzettel-form').after(StimmzettelController.infoModalMessage(titel, text));
	setTimeout(function () {
		$('#close-ok')[0].focus();
	}, 500);
	$('#info-msg').on('hidden.bs.modal', function () {
		LAST_FOCUS_ELEMENT_STIMME.focus();
		document.querySelectorAll('.modal-backdrop').forEach(e => e.remove()); // force remove all backdrop Bootstrap BUG.
		document.querySelectorAll('.modal').forEach(e => e.remove()); // remove all modals
		PRESSED_TIMES = 0;
	});
	$('#info-msg').modal('show');
}

StimmzettelController.showErrorMessage = function (titel, text) {
	$('#error-msg').remove();
	//stimmzettel-form
	$('#stimmzettel-form').after(StimmzettelController.errorModalMessage(titel, text));
	setTimeout(function () {
		$('#close-ok')[0].focus();
	}, 500);
	$('#error-msg').on('hidden.bs.modal', function () {
		LAST_FOCUS_ELEMENT_STIMME.focus();
		document.querySelectorAll('.modal-backdrop').forEach(e => e.remove()); // force remove all backdrop Bootstrap BUG.
		document.querySelectorAll('.modal').forEach(e => e.remove()); // remove all modals
		PRESSED_TIMES = 0;
	});
	$('#error-msg').modal('show');
}

StimmzettelController.printInvalidInput = function (e) {
	StimmzettelController.showErrorMessage('Fehler', 'Die Eingabe <b>"' + e.key + '"</b> ist nicht automatisch interpretierbar.\
	Über diesen Stimmzettel muss durch den Wahlvorstand Beschluss gefasst werden.' );
}


/**
 * BUSINESS FUNKTIONEN
 */
/**
 * Es wird die Aktion zu dem Validator-Modul gesendet
 * @param {*} clickedObject 
 */
StimmzettelController.preValidate = function (clickedObject) {
	//change the JSONStimmzettel and create the JSONStimmzettel to validate
	if (StimmzettelController.typeOf(clickedObject) == 'KANDIDAT_NAME') {
		// change the value
		$.each(JSONStimmzettel.kandidatNamen, function () {
			if (this.stimmzettelpos == clickedObject.stimmzettelpos && this.kandidat == clickedObject.kandidat) {
				this.clicked = !this.clicked
			}
		})
	} else if (StimmzettelController.typeOf(clickedObject) == 'KANDIDAT_SPALTE') {
		// change the value
		$.each(JSONStimmzettel.kandidatSpalten, function () {
			if (this.stimmzettelpos == clickedObject.stimmzettelpos && this.kandidat == clickedObject.kandidat && this.spalte == clickedObject.spalte) {
				this.clicked = !this.clicked
				this.selected = !this.selected
				if (this.clicked == false) { this.value = "" }
				else if (this.clicked == true && (this.value == "X" || this.value == "x" || this.value == "")) this.value = "X";
			}
		})
	}
	else if (StimmzettelController.typeOf(clickedObject) == 'KOPFSTIMME') {
		$.each(JSONStimmzettel.kopfStimmen, function () {
			if (this.stimmzettelpos == clickedObject.stimmzettelpos) {
				this.clicked = !this.clicked
			}
		})
	}

	//Hier wird berchnet das Stimmzettel
	StimmzettelValidator.execute(JSONStimmzettel);

	//Hier wird das Stimmzettel gebaut (das View)
	StimmzettelController.renderStimmzettel(JSONStimmzettel);

}

StimmzettelController.preValidateInput = function (inputObject, reset) {
	domElement = StimmzettelController.getDomElement(inputObject);
	clicked = true;
	if (reset == true) clicked = false;

	if (StimmzettelController.typeOf(inputObject) == 'KANDIDAT_SPALTE') {
		el = JSONStimmzettel.kandidatSpalten.find(obj => obj.stimmzettelpos === inputObject.stimmzettelpos && obj.kandidat == inputObject.kandidat && obj.spalte == inputObject.spalte);
		el.value = domElement.getAttribute("value");
		el.clicked = clicked;
	}

	//Hier wird berchnet das Stimmzettel
	StimmzettelValidator.execute(JSONStimmzettel);

	//Hier wird das Stimmzettel gebaut (VIEW)
	StimmzettelController.renderStimmzettel(JSONStimmzettel);

}

/**
 * DIESE FUNKTION render das Stimmzettel NACH die Pre-Validierung und aktiviert die Elementen
 * @param {*} JSONStimmzettel
 */
StimmzettelController.renderStimmzettel = function (JSONStimmzettel) {
	if (JSONStimmzettel.hinweisText.enabled == true) {
		if (JSONStimmzettel.hinweisText.success == true) {
			$('#stz-hinweis').html('<b>'
				+ JSONStimmzettel.hinweisText.text
				+ '</b>' + '<br/><small>'
				+ JSONStimmzettel.hinweisText.text1 + '</small>'
				+ JSONStimmzettel.hinweisText.text2
				+ '<span><b>' + JSONStimmzettel.hinweisText.text3 + '</b></span>');
			$('#stz-hinweis').removeClass("text-danger");
			$('#stz-hinweis').removeClass("text-success");
			$('#stz-hinweis').addClass("text-success");
		}
		if (JSONStimmzettel.hinweisText.success == false) {
			$('#stz-hinweis').html('<b>' + JSONStimmzettel.hinweisText.text
				+ '</b>' + '<p><small>' + JSONStimmzettel.hinweisText.text2 + '</small>');
			$('#stz-hinweis').removeClass("text-danger");
			$('#stz-hinweis').removeClass("text-success");
			$('#stz-hinweis').addClass("text-danger")
		};
	} else {
		$('#stz-hinweis').html('');
	}

	$.each(JSONStimmzettel.kopfStimmen, function () {
		domElement = StimmzettelController.getDomElement(this);
		if (this.clicked == true) {
			domElement.checked = true;
		}
	});

	$.each(JSONStimmzettel.kandidatNamen, function () {
		domElement = StimmzettelController.getDomElement(this);
		if (this.clicked == true) {
			// CSS class strike .stz-kandidat-streichen
			domElement.setAttribute("class", "stz-kandidat-streichen");
		} else if (this.clicked == false) {
			domElement.removeAttribute("class");
		}

	});

	$.each(JSONStimmzettel.kandidatSpalten, function () {
		domElement = StimmzettelController.getDomElement(this);
		if (this.selected == false) {
			attr = domElement.parentNode.getAttribute("class");

			if (attr.indexOf(' bg-stz-green') >= 0) {
				attr = attr.replace(' bg-stz-green', '');
			}
			if (attr.indexOf(' bg-stz-red') >= 0) {
				attr = attr.replace(' bg-stz-red', '');
			}

			domElement.parentNode.setAttribute("class", attr);

		} else if (this.selected == true && this.error == false) {
			attr = domElement.parentNode.getAttribute("class");

			if (attr.indexOf(' bg-stz-green') < 0) {
				attr = attr + ' bg-stz-green'
			}

			domElement.parentNode.setAttribute("class", attr);

		} else if (this.selected == true && this.error == true) {
			attr = domElement.parentNode.getAttribute("class");

			if (attr.indexOf(' bg-stz-red') < 0) {
				attr = attr + ' bg-stz-red'
			}

			domElement.parentNode.setAttribute("class", attr);

		}
		if (this.clicked == true) {
			domElement.setAttribute("type", "text");
			domElement.setAttribute("value", this.value);
		} else if (this.clicked == false) {
			domElement.removeAttribute("type");
			domElement.removeAttribute("value");

		}

		if (this.value !== undefined && this.value != "") {
			domElement.setAttribute("type", "text");
			domElement.setAttribute("value", this.value);
		}

	});

	JSONStimmzettel.wahlvorschlagMessages.forEach(function (item) {
		domElement = StimmzettelController.getDomElement(item);
		text = domElement.innerText;
		_arr = text.split(' ');
		newText = item.stimmen + ' ' + _arr[1];
		domElement.innerText = newText;
	});


}

//Wenn die Element ist ein KOPFSTIMME, ein KANDIDAT_NAME oder KANDIDAT_SPALTE
StimmzettelController.typeOf = function (obj) {
	if (obj !== null && obj !== undefined && typeof obj === 'object') {
		if (obj.hasOwnProperty('stimmzettelpos')) {
			if (obj.hasOwnProperty('kandidat') && obj.hasOwnProperty('nennung')) {
				return 'KANDIDAT_NAME'
			} else if (obj.hasOwnProperty('kandidat') && obj.hasOwnProperty('spalte')) {
				return 'KANDIDAT_SPALTE'
			} else if (obj.hasOwnProperty('kopfstimme')) {
				return 'KOPFSTIMME'
			}
		}
	}
}

/**
 * UTILITIES
 */
/**
 * get a Dom Element from a JSON Stimmzettel Object
 * @param {*} obj 
 */
StimmzettelController.getDomElement = function (obj) {
	domId = ""
	if (obj.stimmzettelpos !== undefined) {
		domId = "stimmzettelpos" + obj.stimmzettelpos

		if (obj.kandidat !== undefined) {
			domId = domId + "-kandidat" + obj.kandidat
		}

		if (obj.spalte !== undefined) {
			domId = domId + "-spalte" + obj.spalte
		}

		if (obj.nennung !== undefined) {
			domId = domId + "-nennung" + obj.nennung
		}

		if (obj.kopfstimme != undefined) {
			domId = domId + "-kopfstimme" + obj.kopfstimme
		}
	}

	if (obj.wahlvorschlag !== undefined) {
		domId = "wahlvorschlag" + obj.wahlvorschlag + "-msg";
	}

	return document.getElementById(domId);

}

StimmzettelController.elementToJson = function (el) {
	if (typeof el === 'string' || el instanceof String) {
		if (el.indexOf("stimmzettelpos") !== -1 || el.indexOf("wahlvorschlag") !== -1) {
			var arr = el.split("-");
			var obj = {}
			if (el.indexOf("wahlvorschlag") !== -1) {
				var matches = arr[0].match(/(\d+)/);
				var str = arr[arr.length - 1].substring(arr[arr.length - 1].length - matches[0].length, 0);
				obj["wahlvorschlag"] = matches[0]

			} else {
				for (var i = 0; i < arr.length; i++) {
					var matches = arr[i].match(/(\d+)/);
					var str = arr[i].substring(arr[i].length - matches[0].length, 0);
					obj[str] = matches[0]
				}
			}
			return obj
		} else {
			console.error('expected stimmzettelpos but not found :');
		}
	} else {
		console.error('expected String but was :' + typeof el);
	}
}


StimmzettelController.getElementsByIdWildCard = function (name) {
	var allElements = document.getElementsByTagName("*");
	var allIds = [];
	for (var i = 0, n = allElements.length; i < n; ++i) {
		var el = allElements[i];
		if (StimmzettelController.matchWildCards(el.id.toString(), name)) {
			allIds.push(el.id);
		}
	}
	return allIds;
}

StimmzettelController.matchWildCards = function (str, rule) {
	if (str !== "") {
		var escapeRegex = (str) => str.replace(/([.*+?^=!:${}()|\[\]\/\\])/g, "\\$1");
		return new RegExp("^" + rule.split("*").map(escapeRegex).join(".*") + "$").test(str);
	}
}

StimmzettelController.getGestricheneAsObjectForSubmit = function () {
	var gestricheneArray = [];

	$.each($(".stz-kandidat-streichen"), function (key, value) {
		gestricheneArray.push(this.id);
	});

	return {
		"gestrichene": gestricheneArray.toString()
	};
}
/**
 * UI-Animations
 * @param {*} JSONStimmzettelPrev (JSONStimmzettel vor die Berechnung)
 * @param {*} JSONStimmzettel (JSONStimmzettel nach der Berechnung)
 */
StimmzettelController.scrollOnIntersection = function (JSONStimmzettelPrev, JSONStimmzettel) {
	list1 = JSONStimmzettelPrev.kandidatNamen;
	list2 = JSONStimmzettel.kandidatNamen;
	diffNamen = StimmzettelController.differenceClicked(list1, list2);
	list1 = JSONStimmzettelPrev.kandidatSpalten;
	list2 = JSONStimmzettel.kandidatSpalten;
	diffSpalten = StimmzettelController.differenceClicked(list1, list2);
	list1 = JSONStimmzettelPrev.kopfStimmen;
	list2 = JSONStimmzettel.kopfStimmen;
	diffKopfStimmen = StimmzettelController.differenceClicked(list1, list2);
	StimmzettelController.animateDifferences(diffNamen, diffSpalten, diffKopfStimmen);
}

StimmzettelController.focusOnSchnellerfassung = function () {
	var input = document.getElementById('schnellerfassung-input');
	input.focus();
	input.select();
}

// die Stimmzettelpos (integer), die in Focus ist.
FOCUS_POS = null;
StimmzettelController.animateDifferences = function (diffNamen, diffSpalten, diffKopfStimmen) {
	if (Array.isArray(diffNamen) && diffNamen.length) {
		diffNamen.slice().reverse().forEach(function (e) {
			domTarget = StimmzettelController.getDomElement(e);
			StimmzettelController.animate(e);
		});
		FOCUS_POS == null;
	}

	if (Array.isArray(diffSpalten) && diffSpalten.length) {
		diffSpalten.slice().reverse().forEach(function (e) {
			domTarget = StimmzettelController.getDomElement(e);
			StimmzettelController.animate(e);
		});
		FOCUS_POS = null;
	}

	if (Array.isArray(diffKopfStimmen) && diffKopfStimmen.length) {
		diffKopfStimmen.forEach(function (e) {
			StimmzettelController.animate(e);
		});
		FOCUS_POS == null;
	}
}

StimmzettelController.animate = function (e) {
	pos = parseInt(e.stimmzettelpos);
	StimmzettelController.scrollTopListe(pos)
	StimmzettelController.scrollOnElement(e);
}

StimmzettelController.isVisible = function (rect) {
	var h = window.innerHeight;
	if (rect.top + 100 < h) { return true }
	else return false;
}

StimmzettelController.isVisibleTitleList = function (rect) {
	if (rect.top < 30 && Math.sign(rect.top) == 1) {
		return true
	}
	else return false;
}

ID_MESSAGE_BOX = 0;
StimmzettelController.scrollOnElement = function (e) {
	domTarget = StimmzettelController.getDomElement(e);
	var rect = domTarget.getBoundingClientRect();
	idTarget = '#' + domTarget.id;
	if (StimmzettelController.isVisible(rect)) {
	} else {
		var $targetElement = $(idTarget);
		$('html, body').stop().animate({
			'scrollTop': $targetElement.offset().top,
			'scrollLeft': $targetElement.offset().left,
			'scrollRight': $targetElement.offset().right
		}, 0, 'swing', function () {
			window.location.hash = idTarget;
			StimmzettelController.focusOnSchnellerfassung();
		});

		//orange on select
		$(idTarget).animate({
			backgroundColor: "#FFC04C",
		}, 500);
		$(idTarget).animate({
			backgroundColor: "white",
		}, 500);
	}
}

StimmzettelController.positionMessage = function (_element, id, domTarget) {
	//domTarget wird als anchor für di height-Position benuzt.
	anchorHeight = domTarget.getBoundingClientRect().top + window.scrollY;
	var _div = document.getElementById(id);
	_div.style.visibility = 'visible';
	var parentPosition = _element.getBoundingClientRect().left;
	_div.style.left = parentPosition + 'px';
	if (PROBESTIMMZETTEL = true) { heightToList = -window.innerHeight + 320; }
	else { heightToList = anchorHeight; }
	_div.style.top = heightToList + 'px';
}

StimmzettelController.scrollTopListe = function (pos) {
	target = '#wahlvorschlag-liste-' + pos;
	if (FOCUS_POS == null || FOCUS_POS != pos) {
		var $target = $(target);
		$('html, body').stop().animate({
			'scrollTop': $target.offset().top,
			'scrollLeft': $target.offset().left,
			'scrollRight': $target.offset().right
		}, 0, 'swing', function () {
			window.location.hash = target;
			StimmzettelController.focusOnSchnellerfassung();
		});
		//yellow on select
		$(target).animate({
			backgroundColor: "#C0C0C0",
		}, 1000);
		$(target).animate({
			backgroundColor: "white",
		}, 1000);
		FOCUS_POS = pos;
	}
}

StimmzettelController.differenceClicked = function (list1, list2) {
	difference = [];
	i = 0;
	list1.forEach(function (e) {
		if (list2[i].kandidat == e.kandidat && list2[i].clicked != e.clicked) {
			difference.push(list2[i]);
		}
		i++;
	});
	return difference;
}


/**
 * Alte funktionen von stimmzettel.js
 */
function StimmzettelViewKompaktOpenTab(id) {
	$(".nav-pills .active, .tab-content .active").removeClass("active");
	$("#v-pills-" + id + "-tab").addClass("active");
	$("#v-pills-" + id).addClass("active show");

	$('html, body').animate(
		{
			scrollTop: $("#v-pills-" + id).offset().top
				- $("nav.navbar ").outerHeight()
		}, 200);
}

function StorniereStimmzettelAction() {
	$.ajax({
		url: $('#stimmzettel-storno').attr('data-url'),
		context: document.body
	}).done(function (data) {
		window.location.href = updateHrefCsrf("erfassung");
	});
}

function zeigeModalNachStimmzettelSpeichern(clazz, hinweis1, hinweis2,
	zeigeDirektZu) {
	if (zeigeDirektZu) {
		$.get("modal_nachStimmzettelSpeichernMitDirektZu.html", function (data) {
			var dataVar = $(data);
			dataVar.find("#id-stimmzettel-hinweis1").text(hinweis1);
			dataVar.find("#id-stimmzettel-hinweis2").text(hinweis2);
			dataVar.find("#id-stimmzettel-hinweis2").removeClass();
			dataVar.find("#id-stimmzettel-hinweis2").addClass(clazz);

			dataVar.modal({
				backdrop: 'static'
			}).on('hidden.bs.modal', function (e) {
				$("#modalNachStimmzettelSpeichernMitDirektZu").remove();
			}).on('shown.bs.modal', function (e) {
				$("#direktZuStimmzettelInput").focus();
			});
		});
	} else {
		$.get("modal_nachStimmzettelSpeichern.html", function (data) {
			var dataVar = $(data);
			dataVar.find("#id-stimmzettel-hinweis1").text(hinweis1);
			dataVar.find("#id-stimmzettel-hinweis2").text(hinweis2);
			dataVar.find("#id-stimmzettel-hinweis2").removeClass();
			dataVar.find("#id-stimmzettel-hinweis2").addClass(clazz);

			dataVar.modal({
				backdrop: 'static'
			}).on('hidden.bs.modal', function (e) {
				$("#modalNachStimmzettelSpeichern").remove();
			}).on('shown.bs.modal', function (e) {
				$("#link-naechster").focus();
			});
		});
	}
}

function zeigeModalVorStimmzettelSpeichern(hinweis2, mitPassort) {
	if (mitPassort) {
		$.get("modal_vorStimmzettelSpeichernMitPasswort.html", function (data) {
			var dataVar = $(data);
			dataVar.find("#id-stimmzettel-hinweis2").text(hinweis2);

			dataVar.modal().on('hidden.bs.modal', function (e) {
				$("#vorStimmzettelSpeichernModal").remove();
				$("#schnellerfassung-input").focus();
			}).on('shown.bs.modal', function (e) {
				$('#stimmzettel-wirklich-speichern-mit-passwort').click(function () {
					loadFirstCSRF();
					$.ajax({
						url: updateHrefCsrf('erfassung?action=20180727'),
						method: "POST",
						data: { passwort: $("#passwordZumStimmzettelSpeichern").val() }
					}).done(function (data) {
						// 2019-12 Das modal('hide') wird jetzt aus dem Java-Code heraus gemacht.
						//$("#vorStimmzettelSpeichernModal").modal("hide");
					});
				});
				$("#passwordZumStimmzettelSpeichern-mit-passwort").focus();
			});
		});
	} else {
		$.get("modal_vorStimmzettelSpeichern.html", function (data) {
			var dataVar = $(data);
			dataVar.find("#id-stimmzettel-hinweis2").text(hinweis2);

			dataVar.modal().on('hidden.bs.modal', function (e) {
				$("#vorStimmzettelSpeichernModal").remove();
				$("#schnellerfassung-input").focus();
			}).on('shown.bs.modal', function (e) {
				$('#stimmzettel-wirklich-speichern').click(function () {
					// console.log("click registriert");
					$.ajax({
						// Der Parameter schnellerfassung ist nur notwendig, um herauszufinden, ob 
						// die Speicherung via Scan (mit Barcodelesestift) der Nummer des Stimmzettels erfolgte. 
						url: updateHrefCsrf('erfassung?action=20180727&schnellerfassung=' + $("#schnellerfassung-input").val())
					}).done(function (data) {
						// console.log("click registriert - ajax call done ");
						//$("#vorStimmzettelSpeichernModal").modal("hide");
					});
				});
				$("#stimmzettel-wirklich-speichern").focus();
			});
		});
	}
}

function zeigeModalVorStimmzettelSpeichernFehler(hinweis2) {
	$.get("modal_vorStimmzettelSpeichernFehler.html", function (data) {
		var dataVar = $(data);
		dataVar.find("#id-stimmzettel-hinweis2").text(hinweis2);

		dataVar.modal().on('hidden.bs.modal', function (e) {
			$("#vorStimmzettelSpeichernModalFehler").remove();
			$("#schnellerfassung-input").focus();
		});
	});
}

function reheightStimmzettelViewSimple() {
	var container = $("#stz-view-klassisch-container");

	if (container.length > 0) {
		var footer_container = $("#stz-footer-container");
		container.height(footer_container.position().top
			- container.position().top);

		var highest_width = 0;
		$.each($("#stz-view-klassisch-container > table > tbody > tr > td"),
			function (key, value) {
				if (highest_width < $(this).width()) {
					highest_width = $(this).width();
				}
			});
		$.each($("#stz-view-klassisch-container > table > tbody > tr > td"),
			function (key, value) {
				$(this).width(highest_width);
			});

		$(window).resize(

			function () {
				FOCUS_POS = null
				container.height(footer_container.position().top
					- container.position().top);
			});

		// VOT-10959
		$("#stimmzettel-hinweis-text").on("DOMSubtreeModified",
			function () {
				container.height(footer_container.position().top
					- container.position().top);
			});
	}
}

